import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'cnpj_cpf'
})
export class CnpjCpfPipe implements PipeTransform {

  transform(value: string): string {
    if (value) {
      if (value.length === 14) {
        return value.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/g, '\$1.\$2.\$3\/\$4\-\$5');
      } else if (value.length === 10) {
        const addZero = '0' + value;
        return addZero.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/g, '\$1.\$2.\$3\-\$4');
      } else {
        return value.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/g, '\$1.\$2.\$3\-\$4');
      }
    } else {
      return '';
    }
  }

}