'use strict'

/** @type {import('@adonisjs/framework/src/Env')} */
const Logger = use('Logger')
const fs = require('fs')
const Env = use('Env')

module.exports = {
  /*
  |--------------------------------------------------------------------------
  | Authenticator
  |--------------------------------------------------------------------------
  |
  | Authentication is a combination of serializer and scheme with extra
  | config to define on how to authenticate a user.
  |
  | Available Schemes - basic, session, jwt, api
  | Available Serializers - lucid, database
  |
  */
  authenticator: 'sameDay',

  /*
  |--------------------------------------------------------------------------
  | Session
  |--------------------------------------------------------------------------
  |
  | Session authenticator makes use of sessions to authenticate a user.
  | Session authentication is always persistent.
  |
  */
  session: {
    serializer: 'lucid',
    model: 'App/Models/Base/Users',
    scheme: 'session',
    uid: 'cpfcnpj',
    password: 'password'
  },

  /*
  |--------------------------------------------------------------------------
  | Basic Auth
  |--------------------------------------------------------------------------
  |
  | The basic auth authenticator uses basic auth header to authenticate a
  | user.
  |
  | NOTE:
  | This scheme is not persistent and users are supposed to pass
  | login credentials on each request.
  |
  */
  basic: {
    serializer: 'lucid',
    model: 'App/Models/User',
    scheme: 'basic',
    uid: 'cpfcnpj',
    password: 'password'
  },

  /*
  |--------------------------------------------------------------------------
  | Jwt
  |--------------------------------------------------------------------------
  |
  | The jwt authenticator works by passing a jwt token on each HTTP request
  | via HTTP `Authorization` header.
  |
  */
  jwt: {
    serializer: 'lucid',
    model: 'App/Models/Base/Users',
    scheme: 'jwt',
    uid: 'cpfcnpj',
    password: 'password',
    options: {
      secret: Env.get('APP_KEY'),
      expiresIn: Env.get('TOKEN_EXPIRE', '31d'),
    }
  },

  sameDay: {
    serializer: 'lucid',
    model: 'App/Models/Base/Users',
    scheme: 'sameDay',
    uid: 'cpfcnpj',
    password: 'password',
    options: {
      algorithm: 'RS256',
      secret: fs.existsSync(Env.get('APP_OAUTHKEY_PATH', 'authkeys') + '/oauth-private.key') ? fs.readFileSync(Env.get('APP_OAUTHKEY_PATH', 'authkeys') + '/oauth-private.key') : Logger.error('OAuth Keys not found! Please, run `adonis oauth2:key` to generate.'),
      public: fs.existsSync(Env.get('APP_OAUTHKEY_PATH', 'authkeys') + '/oauth-public.key') ? fs.readFileSync(Env.get('APP_OAUTHKEY_PATH', 'authkeys') + '/oauth-public.key') : Logger.error('OAuth Keys not found! Please, run `adonis oauth2:key` to generate.'),
      expiresIn: Env.get('TOKEN_EXPIRE', '31d'),
      notBefore: 0,
    },
  },

  /*
  |--------------------------------------------------------------------------
  | Api
  |--------------------------------------------------------------------------
  |
  | The Api scheme makes use of API personal tokens to authenticate a user.
  |
  */
  api: {
    serializer: 'lucid',
    model: 'App/Models/Base/Users',
    scheme: 'api',
    uid: 'cpfcnpj',
    password: 'password'
  },
}