#!/usr/bin/env python
"""
Script para testar a exibição das fotos
"""
import os
import django

# Configurar Django
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'allure_project.settings')
django.setup()

from models.models import Modelo, FotoModelo

def test_photo_display():
    """Testa a exibição das fotos"""
    print("🔍 Testando exibição das fotos...")
    
    for modelo in Modelo.objects.all():
        print(f"\n📸 {modelo.nome_exibicao} (ID: {modelo.id}):")
        
        # Verificar foto de perfil
        if modelo.foto_perfil:
            print(f"   ✅ Foto de perfil: {modelo.foto_perfil}")
            print(f"   📁 Caminho completo: media/{modelo.foto_perfil}")
            
            # Verificar se o arquivo existe
            file_path = f"media/{modelo.foto_perfil}"
            if os.path.exists(file_path):
                print(f"   ✅ Arquivo existe no sistema")
            else:
                print(f"   ❌ Arquivo NÃO existe no sistema")
        else:
            print(f"   ❌ Nenhuma foto de perfil definida")
        
        # Verificar fotos da galeria
        fotos_galeria = modelo.fotos.filter(categoria='galeria')
        print(f"   📷 Fotos da galeria: {fotos_galeria.count()}")
        
        for foto in fotos_galeria[:2]:  # Mostrar apenas as 2 primeiras
            print(f"      - {foto.imagem}")
            
            # Verificar se o arquivo existe
            file_path = f"media/{foto.imagem}"
            if os.path.exists(file_path):
                print(f"        ✅ Arquivo existe")
            else:
                print(f"        ❌ Arquivo NÃO existe")

def check_url_patterns():
    """Verifica os padrões de URL das fotos"""
    print("\n🌐 Verificando padrões de URL...")
    
    for modelo in Modelo.objects.all()[:3]:  # Apenas 3 primeiras
        if modelo.foto_perfil:
            url = f"http://127.0.0.1:8010/media/{modelo.foto_perfil}"
            print(f"   {modelo.nome_exibicao}: {url}")

if __name__ == '__main__':
    test_photo_display()
    check_url_patterns() 