#!/usr/bin/env python
"""
Script para testar o filtro personalizado de status pendente
"""
import os
import django

# Configurar Django
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'allure_project.settings')
django.setup()

from models.admin import StatusPendenteFilter
from models.models import Modelo

def test_filter():
    """Testa o filtro personalizado"""
    print("🧪 TESTE DO FILTRO PERSONALIZADO")
    print("=" * 40)
    
    # Criar instância do filtro
    filter_instance = StatusPendenteFilter(None, {}, Modelo, None)
    
    # Testar lookups
    print("📋 Lookups disponíveis:")
    lookups = filter_instance.lookups(None, None)
    for value, title in lookups:
        print(f"  - {value}: {title}")
    
    # Fazer a consulta manualmente para testar
    todos_pendentes = Modelo.objects.filter(
        status__in=['cadastro_inicial', 'pendente_validacao', 'pendente_pagamento']
    )
    
    print(f"\n🔍 Testando filtro 'todos_pendentes':")
    print(f"Total de modelos pendentes: {todos_pendentes.count()}")
    for modelo in todos_pendentes:
        print(f"  - {modelo.nome_exibicao} (ID: {modelo.id}) - Status: {modelo.status}")
    
    # Testar filtros individuais
    print("\n🔍 Testando filtros individuais:")
    for status in ['cadastro_inicial', 'pendente_validacao', 'pendente_pagamento']:
        count = Modelo.objects.filter(status=status).count()
        print(f"  - {status}: {count} modelo(s)")

def test_url():
    """Testa a URL do filtro"""
    print("\n🌐 TESTE DA URL DO FILTRO")
    print("=" * 30)
    
    # URL que deve funcionar
    url = "/admin/models/modelo/?status_pendente=todos_pendentes"
    print(f"URL para testar: {url}")
    print("Esta URL deve mostrar todos os modelos pendentes")
    
    # Mostrar as URLs disponíveis
    print("\n📋 URLs disponíveis para teste:")
    print("  - /admin/models/modelo/?status_pendente=todos_pendentes")
    print("  - /admin/models/modelo/?status_pendente=cadastro_inicial")
    print("  - /admin/models/modelo/?status_pendente=pendente_validacao")
    print("  - /admin/models/modelo/?status_pendente=pendente_pagamento")

def main():
    """Função principal"""
    print("🎭 TESTE DO FILTRO PERSONALIZADO - PAINEL ADMIN")
    print("=" * 60)
    
    test_filter()
    test_url()
    
    print("\n" + "=" * 60)
    print("✅ TESTE CONCLUÍDO")
    print("Agora você pode testar o link 'Revisar Pendentes' no painel admin")
    print("O filtro deve mostrar todos os modelos pendentes de uma vez")

if __name__ == "__main__":
    main() 