"""
URLs para o sistema de busca avançada
"""

from django.urls import path
from . import views

app_name = 'search'

urlpatterns = [
    # Busca principal
    path('', views.advanced_search, name='advanced_search'),
    path('rapida/', views.quick_search, name='quick_search'),
    
    # APIs AJAX
    path('api/sugestoes/', views.search_suggestions, name='search_suggestions'),
    path('api/analytics/', views.search_analytics, name='search_analytics'),
    path('api/cidades/<str:estado>/', views.get_cities_by_state, name='get_cities_by_state'),
    path('api/tendencias/', views.search_trends, name='search_trends'),
    path('api/populares/', views.popular_searches, name='popular_searches'),
    
    # Exportação
    path('exportar/', views.search_results_export, name='search_export'),
] 