from django.urls import path
from . import views

app_name = 'payments'

urlpatterns = [
    # Página de teste
    path('teste/', views.test_payment, name='test_payment'),
    
    # Formulários de pagamento (apenas planos de anúncio)
    
    # Páginas de retorno do Mercado Pago
    path('success/<uuid:pagamento_id>/', views.sucesso_pagamento, name='success'),
    path('failure/<uuid:pagamento_id>/', views.falha_pagamento, name='failure'),
    path('pending/<uuid:pagamento_id>/', views.pendente_pagamento, name='pending'),
    
    # Webhook
    path('webhook/', views.webhook, name='webhook'),
    
    # Histórico e detalhes
    path('historico/', views.historico_pagamentos, name='historico'),
    path('detalhes/<uuid:pagamento_id>/', views.detalhes_pagamento, name='detalhes'),
    path('cancelar/<uuid:pagamento_id>/', views.cancelar_pagamento, name='cancelar'),

    # Planos de Anúncio
    path('planos/', views.selecionar_plano, name='selecionar_plano'),
    path('plano/<int:plano_id>/', views.criar_pagamento_plano, name='criar_pagamento_plano'),
    
    # Teste
    path('teste-planos/', views.teste_planos, name='teste_planos'),
    path('teste-fluxo-completo/', views.teste_fluxo_completo, name='teste_fluxo_completo'),
    path('teste-pagamento/<uuid:pagamento_id>/', views.teste_pagamento_simulado, name='teste_pagamento'),
    
    # Checkout com Voucher
    path('checkout/<int:plano_id>/', views.checkout_plano, name='checkout_plano'),
    path('validar-voucher/', views.validar_voucher_ajax, name='validar_voucher_ajax'),
] 