# Generated manually

from django.db import migrations, models
from django.utils.text import slugify


def populate_slugs(apps, schema_editor):
    """Popula os slugs para modelos existentes"""
    Modelo = apps.get_model('models', 'Modelo')
    
    for modelo in Modelo.objects.all():
        if not modelo.slug:
            base_slug = slugify(modelo.nome_exibicao)
            slug = base_slug
            counter = 1
            
            # Verificar se o slug já existe
            while Modelo.objects.filter(slug=slug).exclude(pk=modelo.pk).exists():
                slug = f"{base_slug}-{counter}"
                counter += 1
            
            modelo.slug = slug
            modelo.save()


def reverse_populate_slugs(apps, schema_editor):
    """Remove os slugs (não faz nada)"""
    pass


class Migration(migrations.Migration):

    dependencies = [
        ("models", "0020_fotomodelo_autorizar_redes_sociais"),
    ]

    operations = [
        # Adicionar campo slug sem restrição unique
        migrations.AddField(
            model_name="modelo",
            name="slug",
            field=models.SlugField(
                blank=True, max_length=120, null=True, verbose_name="Slug para URL"
            ),
        ),
        # Popular os slugs
        migrations.RunPython(populate_slugs, reverse_populate_slugs),
        # Adicionar restrição unique
        migrations.AlterField(
            model_name="modelo",
            name="slug",
            field=models.SlugField(
                blank=True, max_length=120, unique=True, verbose_name="Slug para URL"
            ),
        ),
    ]
