# Generated by Django 5.2.4 on 2025-09-02 18:57

from django.db import migrations


def update_biografia_field(apps, schema_editor):
    """Atualiza o campo biografia para registros existentes"""
    Modelo = apps.get_model('models', 'Modelo')
    for modelo in Modelo.objects.all():
        if not modelo.biografia:
            modelo.biografia = ''
            modelo.save()


class Migration(migrations.Migration):
    dependencies = [
        ("models", "0009_modelo_aprovado_por_modelo_data_aprovacao_and_more"),
    ]

    operations = [
        migrations.RunPython(update_biografia_field, reverse_code=migrations.RunPython.noop),
    ]
