# Generated by Django 5.2.4 on 2025-08-25 20:41

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("models", "0007_modelo_biografia"),
    ]

    operations = [
        migrations.CreateModel(
            name="PlanoAnuncio",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("nome", models.CharField(max_length=100)),
                (
                    "tipo",
                    models.CharField(
                        choices=[
                            ("basico", "Básico"),
                            ("premium", "Premium"),
                            ("vip", "VIP"),
                            ("exclusivo", "Exclusivo"),
                        ],
                        max_length=20,
                    ),
                ),
                (
                    "duracao_dias",
                    models.PositiveIntegerField(
                        choices=[
                            (30, "30 dias"),
                            (60, "60 dias"),
                            (90, "90 dias"),
                            (180, "180 dias"),
                            (365, "365 dias"),
                        ]
                    ),
                ),
                ("preco", models.DecimalField(decimal_places=2, max_digits=10)),
                ("destaque_perfil", models.BooleanField(default=False)),
                ("boost_visualizacoes", models.BooleanField(default=False)),
                ("fotos_ilimitadas", models.BooleanField(default=False)),
                ("videos_ilimitados", models.BooleanField(default=False)),
                ("suporte_prioritario", models.BooleanField(default=False)),
                ("relatorio_estatisticas", models.BooleanField(default=False)),
                ("max_fotos", models.PositiveIntegerField(default=10)),
                ("max_videos", models.PositiveIntegerField(default=5)),
                ("ativo", models.BooleanField(default=True)),
                ("ordem", models.PositiveIntegerField(default=0)),
                ("data_criacao", models.DateTimeField(auto_now_add=True)),
                ("data_atualizacao", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Plano de Anúncio",
                "verbose_name_plural": "Planos de Anúncio",
                "ordering": ["ordem", "preco"],
            },
        ),
        migrations.AddField(
            model_name="modelo",
            name="plano_data_fim",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="modelo",
            name="plano_data_inicio",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="modelo",
            name="plano_ativo",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="modelos_ativas",
                to="models.planoanuncio",
            ),
        ),
    ]
