# Generated manually

from django.db import migrations, models
import django.db.models.deletion
import django.core.validators
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('models', '0001_initial'),
    ]

    operations = [
        # Criar modelo Categoria
        migrations.CreateModel(
            name='Categoria',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nome', models.CharField(max_length=100, unique=True)),
                ('descricao', models.TextField(blank=True)),
                ('ativo', models.BooleanField(default=True)),
                ('ordem', models.PositiveIntegerField(default=0)),
                ('data_criacao', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Categoria',
                'verbose_name_plural': 'Categorias',
                'ordering': ['ordem', 'nome'],
            },
        ),
        
        # Renomear Visualizacao para VisualizacaoModelo
        migrations.RenameModel(
            old_name='Visualizacao',
            new_name='VisualizacaoModelo',
        ),
        
        # Adicionar novos campos ao modelo Modelo (com valores padrão)
        migrations.AddField(
            model_name='modelo',
            name='nome',
            field=models.CharField(default='Nome', max_length=100, verbose_name='Nome'),
        ),
        migrations.AddField(
            model_name='modelo',
            name='sobrenome',
            field=models.CharField(default='Sobrenome', max_length=100, verbose_name='Sobrenome'),
        ),
        migrations.AddField(
            model_name='modelo',
            name='cpf',
            field=models.CharField(default='000.000.000-00', max_length=14, verbose_name='CPF'),
        ),
        migrations.AddField(
            model_name='modelo',
            name='data_nascimento',
            field=models.DateField(default=django.utils.timezone.now, verbose_name='Data de Nascimento'),
        ),
        migrations.AddField(
            model_name='modelo',
            name='telegram',
            field=models.CharField(blank=True, max_length=50),
        ),
        migrations.AddField(
            model_name='modelo',
            name='link_contato',
            field=models.URLField(blank=True, verbose_name='Link para Contato'),
        ),
        migrations.AddField(
            model_name='modelo',
            name='pagamento_aprovado',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='modelo',
            name='data_pagamento',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='modelo',
            name='proximo_pagamento',
            field=models.DateTimeField(blank=True, null=True),
        ),
        
        # Alterar status padrão
        migrations.AlterField(
            model_name='modelo',
            name='status',
            field=models.CharField(
                choices=[
                    ('cadastro_inicial', 'Cadastro Inicial'),
                    ('pendente_validacao', 'Pendente Validação'),
                    ('validado', 'Validado'),
                    ('pendente_pagamento', 'Pendente Pagamento'),
                    ('ativo', 'Ativo'),
                    ('rejeitado', 'Rejeitado'),
                    ('suspenso', 'Suspenso'),
                ],
                default='ativo',
                max_length=20
            ),
        ),
        
        # Remover campo categoria antigo
        migrations.RemoveField(
            model_name='modelo',
            name='categoria',
        ),
        
        # Adicionar relacionamento many-to-many com categorias
        migrations.AddField(
            model_name='modelo',
            name='categorias',
            field=models.ManyToManyField(blank=True, to='models.categoria', verbose_name='Categorias de Serviços'),
        ),
        
        # Tornar sobre_mim opcional
        migrations.AlterField(
            model_name='modelo',
            name='sobre_mim',
            field=models.TextField(blank=True, verbose_name='Sobre Mim'),
        ),
        
        # Renomear campo em Favorito
        migrations.RenameField(
            model_name='favorito',
            old_name='data_favoritado',
            new_name='data_favorito',
        ),
        
        # Criar modelo Pagamento
        migrations.CreateModel(
            name='Pagamento',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('valor', models.DecimalField(decimal_places=2, max_digits=10)),
                ('status', models.CharField(
                    choices=[
                        ('pendente', 'Pendente'),
                        ('aprovado', 'Aprovado'),
                        ('rejeitado', 'Rejeitado'),
                        ('cancelado', 'Cancelado'),
                    ],
                    default='pendente',
                    max_length=20
                )),
                ('mercadopago_id', models.CharField(blank=True, max_length=100)),
                ('data_pagamento', models.DateTimeField(blank=True, null=True)),
                ('data_criacao', models.DateTimeField(auto_now_add=True)),
                ('modelo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pagamentos', to='models.modelo')),
            ],
            options={
                'verbose_name': 'Pagamento',
                'verbose_name_plural': 'Pagamentos',
                'ordering': ['-data_criacao'],
            },
        ),
        
        # Adicionar campo data_criacao ao Servico
        migrations.AddField(
            model_name='servico',
            name='data_criacao',
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now),
            preserve_default=False,
        ),
        
        # Alterar ordering do Servico
        migrations.AlterModelOptions(
            name='servico',
            options={
                'ordering': ['-data_criacao'],
                'verbose_name': 'Serviço',
                'verbose_name_plural': 'Serviços',
            },
        ),
        
        # Alterar ordering do Banner
        migrations.AlterModelOptions(
            name='banner',
            options={
                'ordering': ['ordem', '-data_criacao'],
                'verbose_name': 'Banner',
                'verbose_name_plural': 'Banners',
            },
        ),
        
        # Alterar ordering do VisualizacaoModelo
        migrations.AlterModelOptions(
            name='visualizacaomodelo',
            options={
                'ordering': ['-data_visualizacao'],
                'verbose_name': 'Visualização',
                'verbose_name_plural': 'Visualizações',
            },
        ),
        
        # Alterar ordering do Favorito
        migrations.AlterModelOptions(
            name='favorito',
            options={
                'ordering': ['-data_favorito'],
                'verbose_name': 'Favorito',
                'verbose_name_plural': 'Favoritos',
            },
        ),
    ]
