# Generated by Django 5.2.4 on 2025-07-19 13:51

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Banner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('titulo', models.CharField(max_length=200)),
                ('imagem', models.ImageField(upload_to='banners/')),
                ('link', models.URLField(blank=True, null=True)),
                ('ordem', models.PositiveIntegerField(default=0)),
                ('ativo', models.BooleanField(default=True)),
                ('data_criacao', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Banner',
                'verbose_name_plural': 'Banners',
                'ordering': ['ordem'],
            },
        ),
        migrations.CreateModel(
            name='Modelo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nome_exibicao', models.CharField(max_length=100, verbose_name='Nome de Exibição')),
                ('idade', models.PositiveIntegerField(validators=[django.core.validators.MinValueValidator(18), django.core.validators.MaxValueValidator(99)])),
                ('estado', models.CharField(max_length=2)),
                ('cidade', models.CharField(max_length=100)),
                ('etnia', models.CharField(choices=[('branca', 'Branca'), ('negra', 'Negra'), ('parda', 'Parda'), ('asiatica', 'Asiática'), ('indigena', 'Indígena'), ('outra', 'Outra')], max_length=20)),
                ('altura', models.PositiveIntegerField(blank=True, help_text='Altura em centímetros', null=True)),
                ('peso', models.PositiveIntegerField(blank=True, help_text='Peso em quilos', null=True)),
                ('categoria', models.CharField(choices=[('JOB', 'Anúncio'), ('FAN', 'Vendas de Conteúdos'), ('CAM', 'Câmera ao Vivo')], max_length=10)),
                ('tipo_ensaio', models.CharField(choices=[('solo', 'Anúncio Só'), ('dupla', 'Anúncio com Dupla'), ('trio', 'Anúncio com Trio'), ('quarteto', 'Anúncio com Quarteto')], max_length=20)),
                ('local_atendimento', models.CharField(choices=[('local_proprio', 'Local Próprio'), ('motel', 'Motel'), ('hotel', 'Hotel'), ('residencia_cliente', 'Residência do Cliente')], max_length=50)),
                ('sobre_mim', models.TextField(verbose_name='Sobre Mim')),
                ('telefone', models.CharField(blank=True, max_length=20)),
                ('whatsapp', models.CharField(blank=True, max_length=20)),
                ('email_contato', models.EmailField(blank=True, max_length=254)),
                ('foto_perfil', models.ImageField(blank=True, null=True, upload_to='modelos/perfil/')),
                ('documento_rg', models.ImageField(blank=True, null=True, upload_to='modelos/documentos/')),
                ('documento_selfie', models.ImageField(blank=True, null=True, upload_to='modelos/documentos/')),
                ('status', models.CharField(choices=[('pendente', 'Pendente'), ('aprovado', 'Aprovado'), ('rejeitado', 'Rejeitado'), ('suspenso', 'Suspenso')], default='pendente', max_length=20)),
                ('premium', models.BooleanField(default=False)),
                ('boost_ativo', models.BooleanField(default=False)),
                ('boost_expira_em', models.DateTimeField(blank=True, null=True)),
                ('data_cadastro', models.DateTimeField(auto_now_add=True)),
                ('data_atualizacao', models.DateTimeField(auto_now=True)),
                ('ultima_atividade', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='modelo_profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Modelo',
                'verbose_name_plural': 'Modelos',
                'ordering': ['-data_cadastro'],
            },
        ),
        migrations.CreateModel(
            name='FotoModelo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('imagem', models.ImageField(upload_to='modelos/fotos/')),
                ('categoria', models.CharField(choices=[('galeria', 'Galeria'), ('seios', 'Seios'), ('frente', 'Frente'), ('bumbum', 'Bumbum'), ('rosto', 'Rosto')], default='galeria', max_length=20)),
                ('ordem', models.PositiveIntegerField(default=0)),
                ('data_upload', models.DateTimeField(auto_now_add=True)),
                ('modelo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fotos', to='models.modelo')),
            ],
            options={
                'verbose_name': 'Foto da Modelo',
                'verbose_name_plural': 'Fotos das Modelos',
                'ordering': ['ordem', 'data_upload'],
            },
        ),
        migrations.CreateModel(
            name='BoostPagamento',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('duracao_dias', models.PositiveIntegerField(choices=[(7, '7 dias'), (15, '15 dias'), (30, '30 dias')])),
                ('valor', models.DecimalField(decimal_places=2, max_digits=10)),
                ('status', models.CharField(choices=[('pendente', 'Pendente'), ('aprovado', 'Aprovado'), ('rejeitado', 'Rejeitado'), ('cancelado', 'Cancelado')], default='pendente', max_length=20)),
                ('payment_id', models.CharField(blank=True, max_length=100)),
                ('preference_id', models.CharField(blank=True, max_length=100)),
                ('data_solicitacao', models.DateTimeField(auto_now_add=True)),
                ('data_aprovacao', models.DateTimeField(blank=True, null=True)),
                ('modelo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='boost_pagamentos', to='models.modelo')),
            ],
            options={
                'verbose_name': 'Pagamento de Boost',
                'verbose_name_plural': 'Pagamentos de Boost',
                'ordering': ['-data_solicitacao'],
            },
        ),
        migrations.CreateModel(
            name='Servico',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('descricao', models.CharField(max_length=200)),
                ('preco', models.DecimalField(decimal_places=2, max_digits=10)),
                ('duracao', models.CharField(blank=True, help_text='Ex: 1 hora, 30 minutos', max_length=50)),
                ('ativo', models.BooleanField(default=True)),
                ('modelo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='servicos', to='models.modelo')),
            ],
            options={
                'verbose_name': 'Serviço',
                'verbose_name_plural': 'Serviços',
                'ordering': ['preco'],
            },
        ),
        migrations.CreateModel(
            name='Visualizacao',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ip_address', models.GenericIPAddressField()),
                ('user_agent', models.TextField(blank=True)),
                ('data_visualizacao', models.DateTimeField(auto_now_add=True)),
                ('modelo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='visualizacoes', to='models.modelo')),
            ],
            options={
                'verbose_name': 'Visualização',
                'verbose_name_plural': 'Visualizações',
                'ordering': ['-data_visualizacao'],
            },
        ),
        migrations.CreateModel(
            name='Favorito',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('data_favoritado', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='favoritos', to=settings.AUTH_USER_MODEL)),
                ('modelo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='favoritado_por', to='models.modelo')),
            ],
            options={
                'verbose_name': 'Favorito',
                'verbose_name_plural': 'Favoritos',
                'ordering': ['-data_favoritado'],
                'unique_together': {('user', 'modelo')},
            },
        ),
    ]
