from django.urls import path
from . import views

app_name = 'core'

urlpatterns = [
    path('', views.verificacao_idade, name='verificacao_idade'),
    path('home/', views.home, name='home'),
    path('modelo/<slug:modelo_slug>/', views.modelo_detail, name='modelo_detail'),
    path('seja-modelo/', views.seja_modelo, name='seja_modelo'),
    path('termos/', views.termos, name='termos'),
    path('politica-privacidade/', views.politica_privacidade, name='politica_privacidade'),
    path('politica-cookies/', views.politica_cookies, name='politica_cookies'),
    
    # APIs AJAX
    path('api/toggle-favorito/', views.toggle_favorito, name='toggle_favorito'),
    path('api/get-cidades/', views.get_cidades, name='get_cidades'),
    path('api/cidades-com-modelos/', views.get_cidades_com_modelos, name='get_cidades_com_modelos'),
    path('api/ativar-boost/', views.ativar_boost, name='ativar_boost'),
]

