from django.shortcuts import redirect
from django.urls import reverse
from django.contrib import messages


class PlanoPagamentoMiddleware:
    """Middleware para verificar se usuários logados precisam selecionar um plano"""
    
    def __init__(self, get_response):
        self.get_response = get_response
    
    def __call__(self, request):
        # Verificar se o usuário está logado
        if request.user.is_authenticated:
            try:
                # Verificar se é uma modelo
                modelo = request.user.modelo_profile
                
                # URLs que não precisam de verificação de plano
                urls_excluidas = [
                    '/payments/planos/',
                    '/payments/plano/',
                    '/accounts/logout/',
                    '/home/',
                    '/payments/teste-fluxo-completo/',
                    '/payments/teste-planos/',
                    '/admin/',
                    '/static/',
                    '/media/',
                ]
                
                # Verificar se está em uma URL excluída
                current_url = request.path
                if any(url in current_url for url in urls_excluidas):
                    pass
                else:
                    # Verificar se precisa selecionar plano
                    if modelo.status == 'cadastro_inicial':
                        # Só redireciona se não estiver já na página de planos
                        if '/payments/planos/' not in request.path:
                            messages.warning(request, 'Você precisa selecionar um plano para ativar seu perfil.')
                            return redirect('payments:selecionar_plano')
                    
                    # Verificar se tem plano ativo
                    elif modelo.status == 'pendente_pagamento':
                        # Só redireciona se não estiver já na página de planos
                        if '/payments/planos/' not in request.path:
                            messages.warning(request, 'Seu pagamento está pendente. Verifique o status.')
                            return redirect('payments:selecionar_plano')
                        
            except Exception as e:
                # Se não for modelo ou der erro, não aplicar o middleware
                pass
        
        response = self.get_response(request)
        return response
