from django.core.management.base import BaseCommand
from models.models import Categoria


class Command(BaseCommand):
    help = 'Popula as categorias de serviços das modelos'

    def handle(self, *args, **options):
        categorias = [
            'Massagens',
            'Videochamadas',
            'Sexting',
            'Dominatrix',
            'Sado',
            'Despedida Solteiro',
            'Sugar Baby',
            'Almoço',
            'Jantar',
            'Viagens',
            'Festas e Eventos',
            'Fetiches',
            'Clube de Swing',
            'Beijos na Boca',
            'Oral até o fim',
            'Sexo Anal',
            'Facesitting Passiva',
            'Facesitting Ativa',
            'Asslicking Passiva',
            'Asslicking Ativa',
            'Squirting',
            'Garganta Profunda',
            'Oral com preservativo',
            'Brinquedos',
            'Ménage à Trois',
            'Lésbica',
            'Bissexual',
        ]

        for i, nome in enumerate(categorias):
            categoria, created = Categoria.objects.get_or_create(
                nome=nome,
                defaults={
                    'ordem': i + 1,
                    'ativo': True
                }
            )
            
            if created:
                self.stdout.write(
                    self.style.SUCCESS(f'Categoria "{nome}" criada com sucesso.')
                )
            else:
                self.stdout.write(
                    self.style.WARNING(f'Categoria "{nome}" já existe.')
                )

        self.stdout.write(
            self.style.SUCCESS(f'Processo concluído. Total de categorias: {Categoria.objects.count()}')
        ) 