#!/usr/bin/env python3
"""
Script para compilar arquivos SASS
"""
import os
import sys
import subprocess
from pathlib import Path

def compile_sass():
    """Compila os arquivos SASS"""
    project_root = Path(__file__).parent
    scss_file = project_root / 'static' / 'scss' / 'main.scss'
    css_output = project_root / 'static' / 'css' / 'main.css'
    
    # Garante que o diretório de saída existe
    css_output.parent.mkdir(parents=True, exist_ok=True)
    
    try:
        # Compila o SASS
        cmd = [
            'sass',
            str(scss_file),
            str(css_output),
            '--style=compressed'
        ]
        
        result = subprocess.run(cmd, capture_output=True, text=True)
        
        if result.returncode == 0:
            print(f"✅ SASS compilado com sucesso: {css_output}")
        else:
            print(f"❌ Erro ao compilar SASS: {result.stderr}")
            return False
            
    except FileNotFoundError:
        print("❌ SASS não encontrado. Instale com: npm install -g sass")
        return False
    except Exception as e:
        print(f"❌ Erro: {e}")
        return False
    
    return True

if __name__ == '__main__':
    print("🔨 Compilando SASS...")
    success = compile_sass()
    sys.exit(0 if success else 1) 