"""
URLs para o sistema de comunicação
"""
from django.urls import path
from . import views

app_name = 'communication'

urlpatterns = [
    # Dashboard e administração
    path('dashboard/', views.dashboard_comunicacao, name='dashboard'),
    path('estatisticas/', views.estatisticas, name='estatisticas'),
    path('logs/', views.logs_emails, name='logs'),
    
    # Templates
    path('template/<int:template_id>/preview/', views.preview_template, name='preview_template'),
    path('template/<int:template_id>/test/', views.test_email, name='test_email'),
    
    # Processamento
    path('processar-fila/', views.processar_fila, name='processar_fila'),
]
