from django.contrib import admin
from django.contrib.admin import AdminSite
from django.db.models import Count, Q
from django.utils import timezone
from datetime import timedelta


class AllureAdminSite(AdminSite):
    """AdminSite personalizado para o Allure"""
    
    site_header = 'Painel Administrativo Allure'
    site_title = 'Allure Admin'
    index_title = 'Gerenciamento do Site Allure'
    
    def index(self, request, extra_context=None):
        """Personaliza o dashboard com estatísticas"""
        from models.models import Modelo
        from payments.models import TransacaoPagamento
        
        # Estatísticas básicas
        total_modelos = Modelo.objects.count()
        modelos_pendentes = Modelo.objects.filter(
            status__in=['cadastro_inicial', 'pendente_validacao', 'pendente_pagamento']
        ).count()
        modelos_ativas = Modelo.objects.filter(status='ativo').count()
        modelos_premium = Modelo.objects.filter(plano_ativo__isnull=False, plano_data_fim__gt=timezone.now()).count()
        
        # Modelos com plano ativo
        boost_ativos = Modelo.objects.filter(
            plano_ativo__isnull=False,
            plano_data_fim__gt=timezone.now()
        ).count()
        
        # Pagamentos pendentes
        pagamentos_pendentes = TransacaoPagamento.objects.filter(status='pendente').count()
        
        # Pendências específicas
        modelos_cadastro_inicial = Modelo.objects.filter(status='cadastro_inicial').count()
        modelos_pendente_pagamento = Modelo.objects.filter(status='pendente_pagamento').count()
        
        # Contexto adicional para o template
        extra_context = extra_context or {}
        extra_context.update({
            'total_modelos': total_modelos,
            'modelos_pendentes': modelos_pendentes,
            'modelos_ativas': modelos_ativas,
            'modelos_premium': modelos_premium,
            'boost_ativos': boost_ativos,
            'pagamentos_pendentes': pagamentos_pendentes,
            'modelos_cadastro_inicial': modelos_cadastro_inicial,
            'modelos_pendente_pagamento': modelos_pendente_pagamento,
        })
        
        return super().index(request, extra_context)


# Criar instância personalizada do AdminSite
admin_site = AllureAdminSite(name='allure_admin') 