# Sistema de Testes - Projeto Allure

Este documento explica como usar o sistema de testes abrangente criado para o projeto Allure.

## 📋 Visão Geral

O sistema de testes inclui:

- **Testes Unitários**: Testes automatizados para cada app (core, accounts, models)
- **Testes de Funcionalidade**: Verificação de funcionalidades específicas
- **Testes de Integração**: Teste de integração entre componentes
- **Testes de Segurança**: Verificação de aspectos de segurança
- **Verificações de Qualidade**: Análise da estrutura e configuração do projeto

## 🚀 Como Executar os Testes

### 1. Testes Unitários (Django)

```bash
# Executar todos os testes unitários
python manage.py test

# Executar testes de um app específico
python manage.py test core
python manage.py test accounts
python manage.py test models

# Executar um teste específico
python manage.py test core.tests.CoreViewsTestCase.test_home_view
```

### 2. Testes de Funcionalidade

```bash
# Executar testes de funcionalidade
python test_functionality.py
```

Este script testa:
- Configurações do projeto
- URLs e templates
- Banco de dados
- Autenticação
- Views e formulários
- Modelos de dados
- Segurança básica

### 3. Suíte Completa de Testes

```bash
# Executar todos os tipos de testes
python run_all_tests.py
```

Este script executa:
- Todos os testes unitários
- Testes de funcionalidade
- Testes de integração
- Testes de segurança
- Verificações de qualidade

## 📊 Relatórios Gerados

### Relatórios de Testes Unitários
- `test_report.json` - Relatório detalhado em JSON
- `test_report.txt` - Relatório legível em texto

### Relatórios de Funcionalidade
- `functionality_report.json` - Relatório de funcionalidade em JSON
- `functionality_report.txt` - Relatório legível em texto

### Relatório Consolidado
- `consolidated_test_report.json` - Relatório completo em JSON
- `consolidated_test_report.txt` - Relatório completo em texto

## 🧪 Tipos de Testes Implementados

### Testes Unitários (core/tests.py)

#### CoreViewsTestCase
- `test_home_view()` - Testa a página inicial
- `test_modelos_list_view()` - Testa listagem de modelos
- `test_modelo_detail_view()` - Testa detalhes de modelo
- `test_seja_modelo_view()` - Testa cadastro de modelo
- `test_search_modelos()` - Testa busca de modelos
- `test_filter_modelos_by_category()` - Testa filtros

#### CoreFormsTestCase
- `test_modelo_form_valid()` - Testa formulário válido
- `test_modelo_form_invalid_age()` - Testa validação de idade
- `test_modelo_form_missing_required_fields()` - Testa campos obrigatórios
- `test_foto_form_valid()` - Testa formulário de foto

#### CoreModelsTestCase
- `test_modelo_creation()` - Testa criação de modelo
- `test_modelo_str_representation()` - Testa representação string
- `test_categoria_str_representation()` - Testa representação de categoria

#### CoreIntegrationTestCase
- `test_complete_modelo_workflow()` - Testa fluxo completo
- `test_unauthorized_access()` - Testa acesso não autorizado

#### CoreSecurityTestCase
- `test_xss_protection()` - Testa proteção XSS
- `test_sql_injection_protection()` - Testa proteção SQL Injection
- `test_csrf_protection()` - Testa proteção CSRF

### Testes Unitários (accounts/tests.py)

#### AccountsViewsTestCase
- `test_login_view_get()` - Testa página de login
- `test_login_view_post_valid()` - Testa login válido
- `test_login_view_post_invalid()` - Testa login inválido
- `test_logout_view()` - Testa logout
- `test_cadastro_modelo_view_post()` - Testa cadastro de modelo
- `test_editar_perfil_view_post()` - Testa edição de perfil
- `test_painel_modelo_view()` - Testa painel do modelo
- `test_esqueci_senha_view_post()` - Testa recuperação de senha

#### AccountsFormsTestCase
- `test_cadastro_modelo_form_valid()` - Testa formulário de cadastro
- `test_cadastro_modelo_form_passwords_dont_match()` - Testa senhas diferentes
- `test_cadastro_modelo_form_invalid_age()` - Testa idade inválida

#### AccountsSecurityTestCase
- `test_password_validation()` - Testa validação de senha
- `test_csrf_protection_login()` - Testa CSRF no login
- `test_session_security()` - Testa segurança de sessão

### Testes Unitários (models/tests.py)

#### CategoriaModelTestCase
- `test_categoria_creation()` - Testa criação de categoria
- `test_categoria_unique_name()` - Testa nome único
- `test_categoria_deactivation()` - Testa desativação

#### ModeloModelTestCase
- `test_modelo_creation()` - Testa criação de modelo
- `test_modelo_age_validation()` - Testa validação de idade
- `test_modelo_height_validation()` - Testa validação de altura
- `test_modelo_weight_validation()` - Testa validação de peso
- `test_modelo_state_validation()` - Testa validação de estado

#### FotoModelTestCase
- `test_foto_creation()` - Testa criação de foto
- `test_foto_tipo_choices()` - Testa tipos de foto
- `test_foto_modelo_relationship()` - Testa relacionamento

#### BannerModelTestCase
- `test_banner_creation()` - Testa criação de banner
- `test_banner_ordering()` - Testa ordenação

#### ModelRelationshipsTestCase
- `test_user_modelo_relationship()` - Testa relacionamento usuário-modelo
- `test_cascade_delete_user()` - Testa exclusão em cascata

## 🔧 Configuração para Testes

### Pré-requisitos

1. **Ambiente Virtual Ativado**
```bash
source venv/bin/activate  # Linux/Mac
# ou
venv\Scripts\activate     # Windows
```

2. **Dependências Instaladas**
```bash
pip install -r requirements.txt
```

3. **Banco de Dados Configurado**
```bash
python manage.py migrate
```

### Configurações Específicas para Testes

O projeto usa as seguintes configurações para testes:

- **Banco de Dados**: SQLite em memória para testes
- **Email**: Backend de console para testes
- **Arquivos de Mídia**: Diretório temporário para testes

## 📈 Interpretando os Resultados

### Taxa de Sucesso
- **90-100%**: Excelente - Projeto funcionando perfeitamente
- **80-89%**: Bom - Alguns ajustes menores necessários
- **70-79%**: Regular - Revisão recomendada
- **<70%**: Crítico - Correções urgentes necessárias

### Tipos de Problemas

#### Falhas (Failures)
- Testes que falharam mas não causaram erro
- Geralmente indicam problemas de lógica ou validação

#### Erros (Errors)
- Exceções durante a execução dos testes
- Indicam problemas de configuração ou código quebrado

#### Problemas de Funcionalidade
- Funcionalidades que não estão funcionando como esperado
- Requerem correção específica

## 🛠️ Solução de Problemas Comuns

### 1. Erro de Import
```
ImportError: No module named 'core'
```
**Solução**: Verificar se o app está em `INSTALLED_APPS`

### 2. Erro de Template
```
TemplateDoesNotExist: base.html
```
**Solução**: Verificar se o template existe no diretório correto

### 3. Erro de URL
```
NoReverseMatch: Reverse for 'core:home' not found
```
**Solução**: Verificar configuração de URLs no `urls.py`

### 4. Erro de Banco de Dados
```
OperationalError: no such table
```
**Solução**: Executar `python manage.py migrate`

### 5. Erro de Autenticação
```
Authentication credentials were not provided
```
**Solução**: Verificar configurações de autenticação

## 📝 Adicionando Novos Testes

### 1. Teste Unitário
```python
# Em core/tests.py
class NovaFuncionalidadeTestCase(TestCase):
    def setUp(self):
        # Configuração inicial
        
    def test_nova_funcionalidade(self):
        # Teste da nova funcionalidade
        self.assertEqual(resultado_esperado, resultado_real)
```

### 2. Teste de Funcionalidade
```python
# Em test_functionality.py
def test_nova_funcionalidade(self):
    """Testa nova funcionalidade"""
    try:
        # Teste da funcionalidade
        self.log_success("Nova funcionalidade")
    except Exception as e:
        self.log_failure("Nova funcionalidade", str(e))
```

## 🔄 Execução Automática

### Script de Execução Diária
```bash
#!/bin/bash
# daily_tests.sh
cd /path/to/allure_project
source venv/bin/activate
python run_all_tests.py
```

### Integração com CI/CD
```yaml
# .github/workflows/tests.yml
name: Tests
on: [push, pull_request]
jobs:
  test:
    runs-on: ubuntu-latest
    steps:
    - uses: actions/checkout@v2
    - name: Set up Python
      uses: actions/setup-python@v2
      with:
        python-version: 3.9
    - name: Install dependencies
      run: |
        pip install -r requirements.txt
    - name: Run tests
      run: |
        python manage.py test
        python test_functionality.py
```

## 📊 Métricas de Qualidade

### Cobertura de Testes
- **Objetivo**: >80% de cobertura
- **Métricas**: Testes por funcionalidade
- **Relatórios**: Gerados automaticamente

### Performance dos Testes
- **Tempo de Execução**: <30 segundos para suíte completa
- **Memória**: <100MB de uso
- **Recursos**: Otimizados para desenvolvimento

## 🎯 Próximos Passos

1. **Executar os testes** para identificar problemas
2. **Corrigir problemas** encontrados
3. **Adicionar testes** para funcionalidades não cobertas
4. **Configurar execução automática** em CI/CD
5. **Monitorar qualidade** continuamente

## 📞 Suporte

Para dúvidas sobre o sistema de testes:

1. Verifique este README
2. Consulte os relatórios gerados
3. Revise os logs de erro
4. Consulte a documentação do Django

---

**Última atualização**: Dezembro 2024
**Versão**: 1.0
**Autor**: Sistema de Testes Allure 