# 🎨 Desenvolvimento com SASS - Allure Project

Este documento explica como usar o sistema de monitoramento automático SASS no projeto Allure.

## 📋 Pré-requisitos

1. **SASS instalado globalmente:**
   ```bash
   npm install -g sass
   ```

2. **Dependências Python instaladas:**
   ```bash
   pip install -r requirements.txt
   ```

## 🚀 Iniciando o Desenvolvimento

### Opção 1: Script Shell (Recomendado)
```bash
cd allure_project
./dev.sh
```

Este script irá:
- ✅ Ativar o ambiente virtual
- ✅ Instalar dependências
- ✅ Executar migrações se necessário
- ✅ Compilar SASS uma vez
- ✅ Iniciar o servidor Django na porta 8010
- ✅ Iniciar o monitoramento SASS em tempo real

### Opção 2: Python Script
```bash
cd allure_project
python dev_server.py
```

### Opção 3: Manual
```bash
# Terminal 1 - Django Server
cd allure_project
source venv/bin/activate
python manage.py runserver 8010

# Terminal 2 - SASS Watch
cd allure_project
source venv/bin/activate
python watch_sass.py
```

## 📁 Estrutura dos Arquivos SASS

```
static/scss/
├── main.scss                 # Arquivo principal
├── utils/
│   ├── _variables.scss       # Variáveis globais
│   └── _mixins.scss          # Mixins reutilizáveis
├── base/
│   ├── _reset.scss           # Reset CSS
│   ├── _typography.scss      # Tipografia
│   └── _base.scss            # Estilos base
├── components/
│   ├── _buttons.scss         # Botões
│   └── _forms.scss           # Formulários
├── layouts/
│   ├── _header.scss          # Cabeçalho
│   └── _main.scss            # Layout principal
├── pages/
│   ├── _home.scss            # Página inicial
│   ├── _seja_modelo.scss     # Página seja modelo
│   ├── _modelo_detail.scss   # Detalhes do modelo
│   ├── _login.scss           # Login
│   ├── _painel_modelo.scss   # Painel do modelo
│   └── _editar_perfil.scss   # Editar perfil
└── bootstrap/
    └── _customizations.scss  # Personalizações Bootstrap
```

## 🔄 Como Funciona o Monitoramento

O sistema monitora automaticamente:

1. **Arquivos SCSS** (`*.scss`) - Recompila quando modificados
2. **Arquivos CSS** (`*.css`) - Recompila quando modificados (caso você edite diretamente)

### Processo de Compilação:
1. Detecta mudança em arquivo SCSS/CSS
2. Aguarda 1 segundo (evita múltiplas compilações)
3. Executa: `sass main.scss main.css --style=compressed`
4. Mostra status de sucesso/erro

## 📝 Trabalhando com SASS

### 1. Adicionando Novos Estilos

Para adicionar estilos a uma página específica:
```scss
// Em static/scss/pages/_nova_pagina.scss
.nova-pagina {
    // Seus estilos aqui
}
```

E importar no `main.scss`:
```scss
// Em static/scss/main.scss
@use 'pages/nova_pagina' as *;
```

### 2. Usando Variáveis

```scss
// Em static/scss/utils/_variables.scss
$primary-color: #ff6b6b;
$secondary-color: #4ecdc4;

// Em qualquer arquivo SCSS
.button {
    background-color: $primary-color;
    border: 1px solid $secondary-color;
}
```

### 3. Usando Mixins

```scss
// Em static/scss/utils/_mixins.scss
@mixin button-style($bg-color, $text-color) {
    background-color: $bg-color;
    color: $text-color;
    padding: 10px 20px;
    border: none;
    border-radius: 4px;
}

// Em qualquer arquivo SCSS
.my-button {
    @include button-style(#ff6b6b, white);
}
```

## 🔧 Comandos Úteis

### Compilar SASS manualmente:
```bash
python compile_sass.py
```

### Monitorar apenas SASS:
```bash
python watch_sass.py
```

### Verificar se SASS está instalado:
```bash
sass --version
```

## 🐛 Resolução de Problemas

### Erro: "SASS não encontrado"
```bash
npm install -g sass
```

### Erro: "watchdog não encontrado"
```bash
pip install watchdog
```

### Arquivo não está sendo monitorado
- Verifique se o arquivo tem extensão `.scss` ou `.css`
- Verifique se está dentro de `static/scss/` ou `static/css/`
- Reinicie o monitoramento

### CSS não está atualizando no navegador
- Verifique se o arquivo foi compilado corretamente
- Limpe o cache do navegador (Ctrl+F5)
- Verifique se o arquivo CSS gerado está sendo servido pelo Django

## 📊 Logs do Sistema

O sistema mostra logs em tempo real:
```
🔄 Arquivo SCSS alterado: /path/to/file.scss
✅ SASS recompilado com sucesso!
```

Em caso de erro:
```
❌ Erro ao compilar: [mensagem de erro]
```

## 🎯 Dicas de Desenvolvimento

1. **Sempre use o monitoramento** durante o desenvolvimento
2. **Organize os arquivos** por funcionalidade
3. **Use variáveis** para cores e tamanhos repetitivos
4. **Use mixins** para estilos repetitivos
5. **Teste em tempo real** - as mudanças aparecem instantaneamente

## 📞 Suporte

Se encontrar problemas:
1. Verifique os logs no terminal
2. Confirme se todas as dependências estão instaladas
3. Reinicie o monitoramento
4. Verifique a estrutura de arquivos SASS
