# 📋 Guia de Migração - Projeto Allure

Este guia explica como migrar os dados do projeto PHP antigo para o novo projeto Django.

## 🎯 O que será migrado

### ✅ Dados que podem ser migrados:
- **10 modelos aprovadas** com dados completos
- **Fotos das modelos** (galeria, perfil, etc.)
- **Documentos de verificação** (RG, selfie)
- **Serviços e preços** das modelos
- **Banners** da página inicial
- **Categorias** de serviços

### ⚠️ Limitações:
- **Senhas**: Serão redefinidas como `temp_password_123`
- **Histórico de visualizações**: Não será migrado
- **Dados de pagamento**: Não serão migrados

## 🚀 Como executar a migração

### 1. Preparação

Certifique-se de que:
- O projeto Django está configurado corretamente
- O banco de dados está migrado (`python manage.py migrate`)
- A pasta `allure_antigo` está no diretório pai

### 2. Copiar arquivos de mídia

```bash
cd allure_project
python copy_media_files.py
```

Este script irá:
- Copiar todas as fotos das modelos
- Copiar os banners
- Copiar os documentos de verificação

### 3. Migrar dados do banco

```bash
cd allure_project
python migrate_old_data.py
```

Este script irá:
- Criar usuários Django para cada modelo
- Migrar os dados das modelos
- Criar registros de fotos
- Migrar serviços e preços
- Migrar banners

## 📊 Dados que serão migrados

### Modelos (10 registros):
1. **Larissa** (SP) - Premium Pendente
2. **Carol** (SP) - Free
3. **Aninha** (SP) - Free
4. **Brisa e Flora** (SP) - Free
5. **Nice Flora Brisa e Nat** (SP) - Free
6. **Cacau** (SP) - Free
7. **Jenifer** (SC) - Free
8. **Naty Brisa e Flora** (SC) - Premium Pendente
9. **Pamela Pantera** (SP) - Premium Pendente
10. **Bia mello** (SP) - Free

### Serviços:
- Preços variam de R$ 250 a R$ 8.000
- Todos com duração de "1 hora"

### Fotos:
- Fotos de perfil
- Fotos da galeria
- Documentos de verificação

## 🔧 Pós-migração

### 1. Verificar dados migrados

```bash
python manage.py shell
```

```python
from models.models import Modelo, FotoModelo, Servico, Banner

# Verificar modelos
print(f"Modelos migradas: {Modelo.objects.count()}")

# Verificar fotos
print(f"Fotos migradas: {FotoModelo.objects.count()}")

# Verificar serviços
print(f"Serviços migrados: {Servico.objects.count()}")

# Verificar banners
print(f"Banners migrados: {Banner.objects.count()}")
```

### 2. Redefinir senhas

As modelos precisarão redefinir suas senhas no primeiro login. A senha temporária é: `temp_password_123`

### 3. Verificar arquivos de mídia

Certifique-se de que todos os arquivos foram copiados corretamente:

```bash
ls -la media/modelos/
ls -la media/banners/
ls -la media/modelos/documentos/
```

## 🐛 Solução de problemas

### Erro: "Diretório não encontrado"
- Verifique se a pasta `allure_antigo` está no local correto
- Ajuste o caminho em `OLD_UPLOADS_PATH` nos scripts

### Erro: "Modelo já existe"
- O script verifica duplicatas automaticamente
- Se quiser forçar a migração, delete os registros existentes primeiro

### Arquivos de mídia não aparecem
- Verifique as permissões dos diretórios
- Certifique-se de que o Django está configurado para servir arquivos de mídia

## 📝 Notas importantes

1. **Backup**: Sempre faça backup antes da migração
2. **Teste**: Teste em ambiente de desenvolvimento primeiro
3. **Senhas**: As modelos devem redefinir suas senhas
4. **Verificação**: Sempre verifique os dados após a migração

## 🔄 Rollback

Se precisar reverter a migração:

```bash
python manage.py shell
```

```python
from models.models import Modelo, FotoModelo, Servico, Banner
from django.contrib.auth.models import User

# Deletar dados migrados
Modelo.objects.all().delete()
FotoModelo.objects.all().delete()
Servico.objects.all().delete()
Banner.objects.all().delete()

# Deletar usuários criados
User.objects.filter(username__startswith='modelo_').delete()
```

## 📞 Suporte

Se encontrar problemas durante a migração:
1. Verifique os logs de erro
2. Confirme que todos os pré-requisitos foram atendidos
3. Teste em um ambiente limpo primeiro 